@extends('app.base')
@section('content')
    <div class="appHeader bg-primary text-light">
        <div class="left">
            <a href="#" class="headerButton" data-toggle="modal" data-target="#sidebarPanel">
                <ion-icon name="menu-outline"></ion-icon>
            </a>
        </div>
        <div class="pageTitle">
            <img src="{{ url('app/assets/img/logo.png') }}" width="200">
        </div>
        <div class="right">
            <a href="{{ route('app.filtros') }}" class="headerButton">
                <ion-icon name="search-outline"></ion-icon>
            </a>
        </div>
    </div>
    <div id="appCapsule">
        <div style="background: #D5111B">
            <div class="section full mb-3">
                <div class="carousel-single owl-carousel owl-theme">
                    @foreach ($anuncios_destaque as $anuncio)
                        <a href="{{ route('app.anuncio', $anuncio->id) }}">
                            <div class="item">
                                <img src="{{ url("storage/{$anuncio->thumb}") }}" alt="alt" class="img-carrossel">
                                <div class="card-body pt-2">
                                    <h4 class="text-white">
                                        {{ $anuncio->empresa }} <br>
                                        {{ $anuncio->categoria->titulo }}
                                    </h4>
                                </div>
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>
            {{-- <div class="section full mb-3">
                <div class="carousel-multiple owl-carousel owl-theme">
                    @foreach ($anuncios as $anuncio)
                    <div class="item">
                        <div class="card">
                            <img src="{{url("storage/{$anuncio->thumb}")}}" class="img-carrossel" alt="image">
                            <div class="card-body pt-2">
                                <h4>{{lmWord($anuncio->empresa,20)}}</h4>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div> --}}
        </div>
        <div class="section full mt-3">
            <ul class="listview image-listview media search-result mb-2" id="result">
               @foreach ($anuncios as $anuncio)
                <li>
                    <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                        @if (!empty($anuncio->thumb))
                            <div class="imageWrapper">
                                <img src="{{url("storage/{$anuncio->thumb}")}}" alt="image" class="imaged corta-img">
                            </div>
                        @endif
                        <div class="in">
                            <div>
                                <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                                <div class="text-muted">
                                    {{@$anuncio->categoria->titulo}}<br>
                                    {{!empty($anuncio->bairro) ? $anuncio->bairro.', ': ''}} {{$anuncio->cidade}}-{{$anuncio->estado}}
                                    <div class="mt-05"><strong>Publicado em: {{ date('d/m/Y', strtotime($anuncio->created_at))}}</strong></div>
                                </div>
                            </div>
                        </div>
                    </a>
                </li>
               @endforeach
               @foreach ($free as $anuncio)
                <li>
                    <a href="#" onclick="javascript:window.open('{{route('app.anuncio',$anuncio->id)}}', '_self')"  class="item">
                        @if (!empty($anuncio->thumb))
                            <div class="imageWrapper">
                                <img src="{{url("storage/{$anuncio->thumb}")}}" alt="image" class="imaged corta-img">
                            </div>
                        @endif
                        <div class="in">
                            <div>
                                <h4 style="margin-top: -20px;" class="mb-05">{{lmWord($anuncio->empresa, 30)}}</h4>
                                <div class="text-muted">
                                    {{@$anuncio->categoria->titulo}}<br>
                                    {{!empty($anuncio->bairro) ? $anuncio->bairro.', ': ''}} {{$anuncio->cidade}}-{{$anuncio->estado}}
                                    <div class="mt-05"><strong>Publicado em: {{ date('d/m/Y', strtotime($anuncio->created_at))}}</strong></div>
                                </div>
                            </div>
                        </div>
                    </a>
                </li>
               @endforeach
            </ul>
        </div>
    </div>
@endsection
